<?php
session_start();
if (empty($_SESSION['username']))
echo "<script type=text/javascript>window.location='index.php'</script>"; 	

// Get the `id` from the URL
if (isset($_GET['id'])) {
    $id = intval($_GET['id']); // Ensure it's an integer for security
    if ($id <= 0) {
        // Invalid ID
        echo json_encode(["message" => "Invalid ID"]);
        exit;
    }

    // Build the API URL
    $api_url = "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/getcustomerbyid-api.php?id=" . $id;

    // Fetch data from the API
    $response = file_get_contents($api_url);

    // Check if the API call was successful
    if ($response !== false) {
        // Decode the JSON response
        $customer_data = json_decode($response, true);

        // Check if data was retrieved
        if (is_array($customer_data) && !empty($customer_data)) {
			$customer_id = $customer_data["id"];
			$customer_primarycontact = $customer_data["primarycontact"];
			$customer_type = $customer_data["customertype"];
			$phonenumber = $customer_data["phonenumber"];
			$companyname = $customer_data["companyname"];
			$displayname = $customer_data["displayname"];
			$email = $customer_data["email"];
			$phoneno = $customer_data["phoneno"];
			$hasGST = $customer_data["hasGST"];
			$blockcash = $customer_data["blockcash"];
			$gstno = $customer_data["gstno"];
			$name1 = $customer_data["name1"];
			$address = $customer_data["address"];
			$city = $customer_data["city"];
			$state = $customer_data["state"];
			$pincode = $customer_data["pincode"];
			$sname = $customer_data["sname"];
			$sphoneno = $customer_data["sphoneno"];
			$saddress = $customer_data["saddress"];
			$spincode = $customer_data["spincode"];
			$scity = $customer_data["scity"];
			$sstate = $customer_data["sstate"];

        
        } else {
            // No data found or invalid response
            echo json_encode(["message" => "No customer data found or invalid response"]);
        }
    } else {
        // API call failed
        echo json_encode(["message" => "Failed to fetch data from API"]);
    }
} else {
    // 'id' parameter not provided
    echo json_encode(["message" => "ID parameter is required"]);
}
?>




<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Details</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
	<!-- CSS -->


<link rel="stylesheet" type="text/css" href="vendors/styles/core.css">
	<link rel="stylesheet" type="text/css" href="vendors/styles/icon-font.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/dataTables.bootstrap4.min.css">
	<link rel="stylesheet" type="text/css" href="src/plugins/datatables/css/responsive.bootstrap4.min.css">
	
		<link rel="stylesheet" type="text/css" href="vendors/styles/style.css">  

    <style>
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .container {
            background: #fff;
            position: fixed;
            padding: 10px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            margin-top: 0;
            margin-left: 0;
            margin-right: 0;
            z-index: 1;
        }
        .header1 {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 48px;
        }
        .header1 .icons i {
            font-size: 20px;
            cursor: pointer;
        }
        
    .header1 div span {
        font-size: 18px;
        color: #000;
        font-weight: 500;
    }

    p {
        color: #253ED6;
         margin-bottom: 0px;
    }

    .red-box  {
        padding: 80px 15px 0px 15px;
    }
    .red-box h2 {
        font-size: 20px;
        font-weight: bold;
        color: #EF000E;
    }

    .red-box h2 .span-text-p {
        font-size: 16px;
        font-weight: 400;
        color: #000;
    }

    .red-box-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background-color: #FEF2F5;
        padding: 20px;
        border-radius: 10px;
    }

    .container-receive {
            /* background: #fff; */
            padding: 15px;
            /* width: 320px; */
            border-radius: 10px;
            /* box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1); */
        }
        .header-receive {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 16px;
            font-weight: 400;
        }
        .header-receive a {
            text-decoration: none;
            color: #253ED6;
            font-weight: 400;
            display: flex;
            font-size: 16px;
            align-items: center;
        }
        .header-receive i {
            margin-right: 5px;
        }
        .transaction-card {
            background: #fff;
            border-radius: 10px;
            border: 1px solid #ddd;
            padding: 15px;
            margin-top: 10px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .transaction-top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 16px;
            font-weight: 400;
        }
        .amount {
            color: red;
            font-weight: 400;
        }
        .divider {
            border-top: 1px solid #ddd;
            margin: 10px 0;
        }
        .transaction-bottom {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 14px;
        }
        .status {
            display: flex;
            align-items: center;
            font-weight: 400;
            color: green;
        }
        .status i {
            background: green;
            color: white;
            border-radius: 50%;
            padding: 3px;
            margin-right: 5px;
            font-size: 10px;
        }
        .btn-group {
    display: flex;
    position: fixed;
    bottom: 0;
    right: 0;
    border-radius: 10px;
    font-size: 16px;
    font-weight: 400;
    padding: 20px;
    width: 100%;
    justify-content: space-between; /* Ensures spacing between buttons */
}

.btn-group button {
    flex: 1; /* Makes both buttons take equal space */
    display: flex
;
    justify-content: center;
    align-items: center;
}

.btn-group button img {
    width: 37px;
    height: 37px;
}



@media (max-width: 480px) {
    body, h1, h2, h3, h4, h5, h6, .h4, .h5, .page-header h4 {
		font-family: "Noto Sans Devanagari", serif !important;
		font-weight: normal ;
        background-color: white;
	}

    .text-form {
        padding: 55px 15px 0px 15px;
    }

    .input-text,
    .btn-primary-border {
        width: 100% !important;
        padding: 17.5px;
    }

    .input-text:active,
    .input-text:focus,
    .btn-primary-border:active,
    .btn-primary-border:focus {
        border: 1px solid blue;
    }

    .input-text,
    .btn-primary-border {
        border-radius: 5px;
        border: 1px solid #565656;
    }
    .address-bill {
        padding: 10px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        border-radius: 15px;
        border: 1px solid #D9D9D9;
    }

    .label-text {
        position: relative;
    /* top: 25px; */
    /* left: 20px; */
    background: #fff !important;
    font-size: 12px;
    padding: 0px 5px;
    transform: translate(20px, 20px);
    font-weight: 500;
    }

    .space-pad  {
        padding: 20px 0px 0px 0px;
    }

    .bill-text{
        font-size: 16px;
        font-weight: 500;
        color: #000;
    }

    .bill-text1{
        font-size: 16px;
        font-weight: 500;
        color: #565656;
    }

    .address-section {
            margin-top: 15px;
        }
        .address-card {
            border-radius: 10px;
            padding: 20px;
            border: 1px solid #D9D9D9;
            margin-top: 15px;
            display: flex;
            align-items: center;
        }
        .address-card i {
            color: blue;
            font-size: 22px;
        width: 40px;
        height: 40px;
        /* display: flex;
        align-items:center;
        justify-content: center; */
        margin-top: -45px;
        }
        .addresspart{
            margin-top: 35px;
        }
   
    .address-text {
        display: flex;
        flex-direction: column;
        font-size: 16px;
        font-weight: 500;
        line-height: 1.5;
    }

    .btn-group1 {
        display: flex;
        position: fixed;
        bottom: 0;
        right: 0;
        border-radius: 10px;
        font-size: 16px;
        font-weight: 400;
        width: 100%;
        justify-content: space-between;
    }

    .btn-group1 button {
        padding: 15px;
        width: 100%;
    }

    .dropdown-menu {
        width: 100% !important;
        font-size: 16px;
    }


}


    </style>

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Aldrich&family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Noto+Sans+Devanagari:wght@100..900&family=Noto+Sans:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

</head>
<body>

    <div class="container">
        <!-- Header1 Section -->
        <div class="header1">
            <div class="d-flex justify-content-between">
                <a href="customer-details.php?id=<?php echo $id;?>"><i class="fas fa-arrow-left" style="font-size: 24px;"></i></a>&nbsp;&nbsp;&nbsp;&nbsp;<span>Edit Customer</span>
            </div>
            <div class="d-flex align-items-center">
                <p><a href="manageaddress.php?id=<?php echo $id;?>"  style="color: #253ED6;">Manage Addresses</a></p>
            </div>
        </div>
    </div>

    <div class="text-form">
        <form class="mt-4">
            <div>
                <label class="label-text">Name</label>
                <input type="text" id="displayname" value="<?php echo $displayname; ?>" class="input-text">
                <input type="hidden" id="id" value="<?php echo $customer_id;?>" class="input-text">
            </div>
            
           <div>
                <label class="label-text">Phone Number</label>
                <input type="text" class="input-text"  id="phoneno" value="<?php echo $phoneno; ?>">
           </div>

           <div>
                <label class="label-text">Email</label>
                <input type="email" class="input-text" id="email" value="<?php echo $email; ?>">
           </div>

            <div>
                <label class="label-text" style="z-index: 1;position:relative;">Customer Type</label>
               <!-- Dropdown -->
               <div class="dropdown w-100">
                    <button class="btn btn-primary-border w-100 d-flex justify-content-between align-items-center" style="background-color:white;"
                        type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                        <span>Select</span>
                        <i class="fa fa-angle-down"></i>
                    </button>
                    <ul class="dropdown-menu w-100" aria-labelledby="dropdownMenuButton">
                        <li><a class="dropdown-item" href="#" data-value="1">Individual</a></li>
                        <li><a class="dropdown-item" href="#" data-value="2">Business</a></li>
                        <li><a class="dropdown-item" href="#" data-value="3">Vendor</a></li>
                    </ul>
                </div>

                <!-- Hidden Input for Storing Selection -->
                <input type="hidden" id="type" name="customertype" value="<?php echo htmlspecialchars($customer_type, ENT_QUOTES, 'UTF-8'); ?>">

            </div>

            <div class="d-flex align-items-center justify-content-between space-pad">
                <span>Customer has GSTIN. (Optional)</span>
                <div class="toggleBox">
                    <div class="toggle">
                        <input type="checkbox" class="check1" data-id="" id="hasGST"> <!-- Add data-id for unique identification -->
                    </div>
                </div>
            </div>

            <div class="d-flex align-items-center justify-content-between space-pad">
                <span>Block COD for this Customer</span>
                <div class="toggleBox">
                    <div class="toggle">
                    <input type="checkbox" class="check1" data-id="" name="blockcash"  id="blockcash"    <?php if ($blockcash == "1") { echo "checked"; } ?>      value="<?php echo $blockcash; ?>">
                    </div>
                </div>
            </div>


            <div class="addresspart">
                <div class="address-section">
                    <h6>Billing Address</h6>
                    <div class="address-card">
                        <i class="fas fa-map-marker-alt text-primary bg-light"></i>
                        <div class="address-text">
                            <h6><?php echo $name1; ?></h6>
                            <div style="color: #565656;"><?php echo $phonenumber;  ?></div>
                            <div style="color: #565656;"><?php echo $address;  ?>, <?php echo $city;  ?>, <?php echo $state; ?> - <?php echo $pincode;  ?> </div>
                        </div>
                    </div>
                </div>
<br>
                <div class="address-section">
                    <h6>Shipping Address</h6>
                    <div class="address-card">
                        <i class="fas fa-map-marker-alt text-primary bg-light"></i>
                        <div class="address-text">
                            <h6><?php     echo  $sname;   ?></h6>
                            <div style="color: #565656;"><?php   echo  $sphoneno;  ?></div>
                            <div style="color: #565656;"><?php    echo  $saddress;      ?>, <?php    echo $scity;   ?>, <?php   echo $sstate;   ?> - <?php    echo  $spincode;?></div>
                        </div>
                    </div>
                </div>
            </div>


        </form>
    </div>
    <br><br><br><br>

    <div class="btn-group1">
        <button class="btn-primary justify-content-center" id="savebtn">
            <span class="fa fa-save"></span>&nbsp;&nbsp; SAVE
        </button>
    </div>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const dropdownButton = document.getElementById('dropdownMenuButton');
    const dropdownItems = document.querySelectorAll('.dropdown-item');
    const icon = dropdownButton.querySelector('i');
    const hiddenInput = document.getElementById('type');

    // Attach event listeners to all dropdown items
    dropdownItems.forEach(item => {
        item.addEventListener('click', function (e) {
            e.preventDefault();
            const selectedValue = this.getAttribute('data-value');
            const selectedText = this.textContent.trim();

            // Update hidden input field and dropdown button text
            hiddenInput.value = selectedValue;
            dropdownButton.querySelector('span').textContent = selectedText;
        });
    });

    // Toggle icon on dropdown show/hide
    document.querySelector('.dropdown').addEventListener('shown.bs.dropdown', function () {
        icon.classList.replace('fa-angle-down', 'fa-angle-up');
    });

    document.querySelector('.dropdown').addEventListener('hidden.bs.dropdown', function () {
        icon.classList.replace('fa-angle-up', 'fa-angle-down');
    });

    // Set the selected value based on PHP data
    const phpValue = hiddenInput.value.trim();
    if (phpValue) {
        const selectedItem = document.querySelector(`.dropdown-item[data-value="${phpValue}"]`);
        if (selectedItem) {
            dropdownButton.querySelector('span').textContent = selectedItem.textContent.trim();
        }
    }
});document.addEventListener('DOMContentLoaded', function () {
    const dropdownButton = document.getElementById('dropdownMenuButton');
    const dropdownItems = document.querySelectorAll('.dropdown-item');
    const icon = dropdownButton.querySelector('i');
    const hiddenInput = document.getElementById('type');

    // Attach event listeners to all dropdown items
    dropdownItems.forEach(item => {
        item.addEventListener('click', function (e) {
            e.preventDefault();
            const selectedValue = this.getAttribute('data-value');
            const selectedText = this.textContent.trim();

            // Update hidden input field and dropdown button text
            hiddenInput.value = selectedValue;
            dropdownButton.querySelector('span').textContent = selectedText;
        });
    });

    // Toggle icon on dropdown show/hide
    document.querySelector('.dropdown').addEventListener('shown.bs.dropdown', function () {
        icon.classList.replace('fa-angle-down', 'fa-angle-up');
    });

    document.querySelector('.dropdown').addEventListener('hidden.bs.dropdown', function () {
        icon.classList.replace('fa-angle-up', 'fa-angle-down');
    });

    // Set the selected value based on PHP data
    const phpValue = hiddenInput.value.trim();
    if (phpValue) {
        const selectedItem = document.querySelector(`.dropdown-item[data-value="${phpValue}"]`);
        if (selectedItem) {
            dropdownButton.querySelector('span').textContent = selectedItem.textContent.trim();
        }
    }
});
document.addEventListener('DOMContentLoaded', function () {
    var checkbox = document.querySelector('.check1');

    if (checkbox) {
        checkbox.addEventListener('change', function () {
            this.value = this.checked ? "1" : "0"; // Set value based on toggle state
        });
    }
});


document.getElementById('savebtn').addEventListener('click', function(event) {
    event.preventDefault(); // Prevent form submission

    // Collect form data by ID
    const data = {
        date: new Date().toISOString().split('T')[0], // Get current date in YYYY-MM-DD format
        id: document.getElementById('id').value || '',
        displayname: document.getElementById('displayname').value || '',
        phoneno: document.getElementById('phoneno').value || '',
        email: document.getElementById('email').value || '',
        type: document.getElementById('type').value || '',
     //   gstno: document.getElementById('gstno').value || '',
       // companyname: document.getElementById('companyname').value || '',
        blockcash: document.getElementById('blockcash').checked ? 1 : 0,
        hasGST: document.getElementById('hasGST').checked ? 1 : 0
    };

    // API endpoint
    const api_url = "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/updatecustomer-api.php";

    // Send data using fetch
    fetch(api_url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(responseData => {
        console.log('Success:', responseData);
        window.location.href = 'customer.php'; // Redirect after success
    })
    .catch(error => {
        console.error('Error:', error);
    });
});

    </script>
	<script src="vendors/scripts/core.js"></script>
	<script src="vendors/scripts/script.min.js"></script>
	<script src="vendors/scripts/process.js"></script>
	<script src="vendors/scripts/layout-settings.js"></script>
	<script src="src/plugins/datatables/js/jquery.dataTables.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/dataTables.responsive.min.js"></script>
	<script src="src/plugins/datatables/js/responsive.bootstrap4.min.js"></script>
	<!-- buttons for Export datatable -->
	<script src="src/plugins/datatables/js/dataTables.buttons.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.bootstrap4.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.print.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.html5.min.js"></script>
	<script src="src/plugins/datatables/js/buttons.flash.min.js"></script>
	<script src="src/plugins/datatables/js/pdfmake.min.js"></script>
	<script src="src/plugins/datatables/js/vfs_fonts.js"></script>
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
